/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.beans.JCTabEditor;
import jclass.table3.BeanFileDataSource;
import jclass.table3.EditableVectorDataSource;
import jclass.table3.JCCellRange;
import jclass.table3.JCSelectEvent;
import jclass.table3.JCSelectListener;
import jclass.table3.JCTblConverter;
import jclass.table3.LiveTable;
import jclass.table3.MessageBox;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.PropertyEditorTable;
import jclass.table3.Series;
import jclass.table3.SeriesUtil;
import jclass.table3.TableData;
import jclass.table3.VectorDataSource;

public abstract class SeriesEditor
extends JCTabEditor
implements ActionListener,
ItemListener,
JCSelectListener,
FocusListener {
    protected PropertyEditorTable tableView;
    protected Object initValue;
    protected String nl = "<NL>";
    protected int selectionPolicy;
    protected static final int SELECT_NONE = 0;
    protected static final int SELECT_CELLS = 1;
    protected static final int SELECT_ALL = 2;
    protected static final int SELECT_COLUMNS = 3;
    protected static final int SHOW_COLUMNS = 4;
    protected Choice choiceRow;
    protected Choice choiceColumn;
    protected TextField textRow;
    protected TextField textColumn;
    protected TextField textWidth;
    protected TextField textHeight;
    protected Button buttonResetAll;
    protected static final String RANGE = "Range";
    protected static final String ALL_CELLS = "All cells";
    protected static final String ALL = "All";
    protected static final String LABEL = "Label";
    private boolean messageBoxExposed = false;
    private static Frame dialogFrame = null;

    public SeriesEditor() {
        this(2);
    }

    public SeriesEditor(int n) {
        this.selectionPolicy = n;
        this.init();
    }

    public boolean setValue(Series series, JCCellRange jCCellRange, Object object) {
        return SeriesUtil.setValue(this.tableView, series, jCCellRange, object);
    }

    protected void init() {
        this.tableView = new PropertyEditorTable();
        this.tableView.setName("tableView");
        this.tableView.setSelectionPolicy(2);
        this.tableView.clearSelectedCells();
        this.tableView.setAllowCellResize(0);
        this.tableView.setColumnLabelDisplay(true);
        this.tableView.setRowLabelDisplay(true);
        this.tableView.setEditable(-998, -998, false);
        this.tableView.setPixelWidth(-998, 33001);
        this.tableView.setPixelHeight(-998, 33001);
        this.tableView.setCellRenderer(-998, -998, this.getPropertyCellRenderer());
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(6);
        borderLayout.setHgap(6);
        this.setLayout(borderLayout);
        this.add("North", this.makePropertyPanel());
        this.add("Center", this.tableView);
        this.add("East", this.makeControlPanel());
        this.updateSizePanel();
        this.tableView.addSelectListener(this);
        this.textWidth.addFocusListener(this);
        this.textHeight.addFocusListener(this);
        this.textWidth.addActionListener(this);
        this.textHeight.addActionListener(this);
        if (this.selectionPolicy != 0 && this.selectionPolicy != 4) {
            this.tableView.setSelectedCells(new JCCellRange(0, 0, 0, 0));
        }
    }

    public PropertyEditorTable getTableView() {
        return this.tableView;
    }

    public void setValue(Object object) {
        if (this.initValue == null) {
            this.initValue = object;
        }
    }

    public String getAsText() {
        return String.valueOf(this.getValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonResetAll)) {
            this.resetSeries();
            return;
        }
        if (object.equals(this.textRow) || object.equals(this.textColumn)) {
            this.selectCells();
            return;
        }
        if (object.equals(this.textWidth) || object.equals(this.textHeight)) {
            this.resizeTable();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals(this.textWidth) || object.equals(this.textHeight)) {
            this.resizeTable();
            return;
        }
        if (object.equals(this.textRow) || object.equals(this.textColumn)) {
            this.selectCells();
        }
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getAsText();
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceRow) || object.equals(this.choiceColumn)) {
            JCCellRange jCCellRange = new JCCellRange();
            if (!this.tableView.getSelectedRange(0, jCCellRange)) {
                return;
            }
            if (jCCellRange.start_row < 0) {
                jCCellRange.start_row = 0;
            }
            if (jCCellRange.end_row < jCCellRange.start_row) {
                jCCellRange.end_row = jCCellRange.start_row;
            }
            if (jCCellRange.start_column < 0) {
                jCCellRange.start_column = 0;
            }
            if (jCCellRange.end_column < jCCellRange.start_column) {
                jCCellRange.end_column = jCCellRange.start_column;
            }
            if (object.equals(this.choiceRow)) {
                this.enable(this.textRow, this.choiceRow.getSelectedItem().compareTo(RANGE) == 0, jCCellRange.start_row, jCCellRange.end_row);
            } else if (object.equals(this.choiceColumn)) {
                this.enable(this.textColumn, this.choiceColumn.getSelectedItem().compareTo(RANGE) == 0, jCCellRange.start_column, jCCellRange.end_column);
            }
            if (!this.checkSelection()) {
                return;
            }
            this.selectCells();
        }
    }

    public void selectBegin(JCSelectEvent jCSelectEvent) {
    }

    public void selectEnd(JCSelectEvent jCSelectEvent) {
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        boolean bl = this.setChoice(jCCellRange, jCCellRange.start_column, jCCellRange.end_column, this.tableView.getNumColumns() - 1, this.choiceColumn);
        this.enable(this.textColumn, bl, jCCellRange.start_column, jCCellRange.end_column);
        bl = this.setChoice(jCCellRange, jCCellRange.start_row, jCCellRange.end_row, this.tableView.getNumRows() - 1, this.choiceRow);
        this.enable(this.textRow, bl, jCCellRange.start_row, jCCellRange.end_row);
        this.updatePropertyPanel(jCCellRange);
    }

    public Frame findParent() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container == null) {
            if (dialogFrame == null) {
                dialogFrame = new Frame();
            }
            container = dialogFrame;
        }
        return (Frame)container;
    }

    private void resetSeries() {
        if (this.initValue != null) {
            this.setValue(this.initValue);
            JCCellRange jCCellRange = new JCCellRange();
            if (this.tableView.getSelectedRange(0, jCCellRange)) {
                this.updatePropertyPanel(jCCellRange);
                return;
            }
            this.updatePropertyPanel(null);
        }
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return null;
    }

    protected abstract Component makePropertyPanel();

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
    }

    protected Component makeSelectionPanel() {
        this.choiceRow = new Choice();
        this.choiceColumn = new Choice();
        this.textRow = new TextField("0", 5);
        this.textColumn = new TextField("0", 5);
        if (this.selectionPolicy == 3) {
            this.choiceRow.add(ALL);
        } else {
            this.choiceRow.add(RANGE);
            this.choiceRow.add(ALL_CELLS);
            if (this.selectionPolicy == 2) {
                this.choiceRow.add(ALL);
                this.choiceRow.add(LABEL);
            }
        }
        this.choiceColumn.add(RANGE);
        this.choiceColumn.add(ALL_CELLS);
        if (this.selectionPolicy == 2 || this.selectionPolicy == 3) {
            this.choiceColumn.add(ALL);
            this.choiceColumn.add(LABEL);
        }
        GroupPanel groupPanel = new GroupPanel("Selected region");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new Label("Row"), gridBagConstraints);
        groupPanel.add((Component)this.choiceRow, gridBagConstraints);
        groupPanel.add((Component)this.textRow, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Column"), gridBagConstraints);
        groupPanel.add((Component)this.choiceColumn, gridBagConstraints);
        groupPanel.add((Component)this.textColumn, gridBagConstraints);
        this.choiceRow.addItemListener(this);
        this.choiceColumn.addItemListener(this);
        this.textRow.addFocusListener(this);
        this.textColumn.addFocusListener(this);
        this.textRow.addActionListener(this);
        this.textColumn.addActionListener(this);
        return groupPanel;
    }

    protected Component makeSizeResetPanel() {
        this.textWidth = new TextField(3);
        this.textHeight = new TextField(3);
        this.buttonResetAll = new Button("Reset All");
        GroupPanel groupPanel = new GroupPanel("Table size");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)this.textHeight, gridBagConstraints);
        groupPanel.add((Component)new Label("rows"), gridBagConstraints);
        groupPanel.add((Component)this.textWidth, gridBagConstraints);
        groupPanel.add((Component)new Label("columns"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.buttonResetAll);
        Panel panel2 = new Panel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(6);
        panel2.setLayout(borderLayout);
        panel2.add("Center", groupPanel);
        panel2.add("South", panel);
        this.buttonResetAll.addActionListener(this);
        return panel2;
    }

    protected Component makeControlPanel() {
        Panel panel = new Panel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        panel.setLayout(borderLayout);
        if (this.selectionPolicy != 0 && this.selectionPolicy != 4) {
            panel.add("North", this.makeSelectionPanel());
            panel.add("South", this.makeSizeResetPanel());
        } else {
            panel.add("North", this.makeSizeResetPanel());
        }
        return panel;
    }

    protected void updateSize() {
        if (this.updateTableSize()) {
            this.updateSizePanel();
        }
    }

    protected void updateSizePanel() {
        TableData tableData = this.tableView.getDataSource();
        boolean bl = !(tableData instanceof BeanFileDataSource);
        this.enable(this.textWidth, bl, 0, 0);
        this.enable(this.textHeight, bl, 0, 0);
        if (bl) {
            int n = ((VectorDataSource)tableData).getNumColumns();
            int n2 = ((VectorDataSource)tableData).getNumRows();
            String string = String.valueOf(n);
            String string2 = String.valueOf(n2);
            if (string.compareTo(this.textWidth.getText()) != 0) {
                ((TextComponent)this.textWidth).setText(string);
            }
            if (string2.compareTo(this.textHeight.getText()) != 0) {
                ((TextComponent)this.textHeight).setText(string2);
            }
        }
    }

    protected boolean updateTableSize() {
        boolean bl = false;
        TableData tableData = this.tableView.getDataSource();
        if (tableData instanceof VectorDataSource) {
            int n = LiveTable.getNumEditorColumns();
            if (((EditableVectorDataSource)tableData).getNumColumns() != n) {
                ((EditableVectorDataSource)tableData).setNumColumns(n);
                bl = true;
            }
            int n2 = LiveTable.getNumEditorRows();
            if (((EditableVectorDataSource)tableData).getNumRows() != n2) {
                ((EditableVectorDataSource)tableData).setNumRows(n2);
                bl = true;
            }
        }
        return bl;
    }

    protected JCCellRange getSelectedRange() {
        if (this.tableView.selected_cells.size() == 0) {
            return null;
        }
        JCCellRange jCCellRange = new JCCellRange();
        jCCellRange.reshape((JCCellRange)this.tableView.selected_cells.elementAt(0));
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange.start_row = -998;
            jCCellRange.end_row = -999;
        } else if (jCCellRange.start_row == 0 && jCCellRange.end_row == this.tableView.getNumRows() - 1) {
            jCCellRange.start_row = -997;
            jCCellRange.end_row = -999;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange.start_column = -998;
            jCCellRange.end_column = -999;
        } else if (jCCellRange.start_column == 0 && jCCellRange.end_column == this.tableView.getNumColumns() - 1) {
            jCCellRange.start_column = -997;
            jCCellRange.end_column = -999;
        }
        return jCCellRange;
    }

    protected void errorMessageBox(String string) {
        if (this.messageBoxExposed) {
            return;
        }
        this.messageBoxExposed = true;
        MessageBox messageBox = new MessageBox(this.findParent(), "Error");
        messageBox.showMessage(string);
        this.messageBoxExposed = false;
    }

    private void selectCells() {
        if (!this.checkSelection()) {
            return;
        }
        int n = this.getStart(this.choiceRow.getSelectedItem(), this.textRow.getText());
        int n2 = this.getEnd(this.choiceRow.getSelectedItem(), this.textRow.getText());
        int n3 = this.getStart(this.choiceColumn.getSelectedItem(), this.textColumn.getText());
        int n4 = this.getEnd(this.choiceColumn.getSelectedItem(), this.textColumn.getText());
        if (n2 == -999) {
            n2 = n;
        }
        if (n4 == -999) {
            n4 = n3;
        }
        if (n == -999 || n3 == -999) {
            this.tableView.clearSelectedCells();
            return;
        }
        this.tableView.clearSelectedCells();
        JCCellRange jCCellRange = new JCCellRange(n, n3, n2, n4);
        this.updatePropertyPanel(jCCellRange);
        if (jCCellRange.start_row == -998) {
            jCCellRange.start_row = -1;
            jCCellRange.end_row = Integer.MAX_VALUE;
        }
        if (jCCellRange.start_column == -998) {
            jCCellRange.start_column = -1;
            jCCellRange.end_column = Integer.MAX_VALUE;
        }
        if (jCCellRange.start_row == -997) {
            jCCellRange.start_row = 0;
            jCCellRange.end_row = this.tableView.getNumRows() - 1;
        }
        if (jCCellRange.start_column == -997) {
            jCCellRange.start_column = 0;
            jCCellRange.end_column = this.tableView.getNumColumns() - 1;
        }
        this.tableView.setSelectedCells(jCCellRange);
    }

    private int getInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private int getStart(String string, String string2) {
        if (string.compareTo(RANGE) == 0) {
            return this.getRangeInt(string2, true);
        }
        if (string.compareTo(ALL_CELLS) == 0) {
            return -997;
        }
        if (string.compareTo(ALL) == 0) {
            return -998;
        }
        return -1;
    }

    private int getEnd(String string, String string2) {
        if (string.compareTo(RANGE) == 0) {
            return this.getRangeInt(string2, false);
        }
        if (string.compareTo(ALL_CELLS) == 0) {
            return -997;
        }
        if (string.compareTo(ALL) == 0) {
            return -998;
        }
        return -1;
    }

    private void enable(TextField textField, boolean bl, int n, int n2) {
        String string = n != n2 ? String.valueOf(n) + "," + n2 : String.valueOf(n);
        textField.setEnabled(bl);
        ((TextComponent)textField).setText(bl ? string : "");
    }

    private boolean setChoice(JCCellRange jCCellRange, int n, int n2, int n3, Choice choice) {
        if (n == -998) {
            choice.select(ALL);
        } else if (n == -997 || n == 0 && n2 == n3) {
            choice.select(ALL_CELLS);
        } else if (n == -1 && n2 == -1) {
            choice.select(LABEL);
        } else {
            choice.select(RANGE);
            return true;
        }
        return false;
    }

    private boolean checkSelection() {
        if (!this.isLabel(this.choiceRow.getSelectedItem(), this.textRow.getText()) || !this.isLabel(this.choiceColumn.getSelectedItem(), this.textColumn.getText())) {
            if (this.invalidRange(this.choiceRow.getSelectedItem(), this.textRow.getText())) {
                ((TextComponent)this.textRow).setText("0");
            } else if (this.invalidRange(this.choiceColumn.getSelectedItem(), this.textColumn.getText())) {
                ((TextComponent)this.textColumn).setText("0");
            } else {
                return true;
            }
        }
        this.errorMessageBox("The selected region is invalid.");
        return false;
    }

    private boolean isLabel(String string, String string2) {
        return string.compareTo(LABEL) == 0 || string.compareTo(RANGE) == 0 && this.getStart(string, string2) < 0;
    }

    private boolean invalidRange(String string, String string2) {
        return string.compareTo(RANGE) == 0 && this.getStart(string, string2) < -1;
    }

    private void resizeTable() {
        int n = this.getInt(this.textWidth.getText());
        int n2 = this.getInt(this.textHeight.getText());
        LiveTable.setNumEditorColumns(n);
        LiveTable.setNumEditorRows(n2);
        this.updateSize();
    }

    private int getRangeInt(String string, boolean bl) {
        try {
            return JCTblConverter.getRangeInt(string, bl);
        }
        catch (NumberFormatException numberFormatException) {
            return -999;
        }
    }
}

